package gov.va.vinci.dart.json.builder;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;

import org.testng.Assert;
import org.testng.annotations.BeforeTest;
import org.testng.annotations.Test;

import gov.va.vinci.dart.common.SingletonShim;
import gov.va.vinci.dart.common.test.BusinessIntegrationTest;
import gov.va.vinci.dart.biz.EventSummary;
import gov.va.vinci.dart.json.EventHistoryView;
import gov.va.vinci.dart.json.EventRequestView;
import gov.va.vinci.dart.json.EventView;
import gov.va.vinci.dart.service.DartObjectFactory;

public class TestEventHistoryViewBuilder extends BusinessIntegrationTest {

	@BeforeTest
	public void setup() {
		SingletonShim.getBean(DartObjectFactory.class);
	}

	@Test
	public void testOne() throws Exception {
		EventHistoryViewBuilder builder = new EventHistoryViewBuilder();
		
		try {
			builder.build(null);
			Assert.fail("Expected NullPointerException");
		} catch (NullPointerException e) {}
		
		List<EventSummary> eventList = new ArrayList<EventSummary>();
		
		EventHistoryView ehv = builder.build(eventList);
		Assert.assertNotNull(ehv);
		Assert.assertNotNull(ehv.getRequests());
		Assert.assertEquals(ehv.getRequests().size(), 0);
		
		EventSummary es = new EventSummary();
		es.setActivityId(1);
		es.setRequestId(2);
		es.setAmendment(false);
		es.setCreatedBy("createdBy");
		es.setDescription("description");
		es.setRequestTrackingNumber("requestTrackingNumber");
		java.sql.Timestamp testTimestamp = new java.sql.Timestamp(System.currentTimeMillis());
		es.setCreatedOn(testTimestamp);
		
		eventList.add(es);
		
		ehv = builder.build(eventList);
		Assert.assertNotNull(ehv);
		Assert.assertNotNull(ehv.getRequests());
		Assert.assertEquals(ehv.getRequests().size(), 1);
		Assert.assertTrue(ehv.getRequests().get(0) instanceof EventRequestView);
		
		EventRequestView erv = (EventRequestView)ehv.getRequests().get(0);
		Assert.assertNotNull(erv);
		Assert.assertEquals(erv.getRequestId(), 2);
		Assert.assertEquals(erv.getTrackingNumber(), "requestTrackingNumber");
		Assert.assertNotNull(erv.getEvents());
		Assert.assertEquals(erv.getEvents().size(), 1);
		
		EventView ev = erv.getEvents().get(0);
		Assert.assertNotNull(ev);
		Assert.assertEquals(ev.getDescription(), "description");
		Assert.assertEquals(ev.getPerson(), "createdBy");
		
		SimpleDateFormat sdf = new SimpleDateFormat("MM/dd/yyyy hh:mm aa");
		Assert.assertEquals(ev.getDateTime(), sdf.format(testTimestamp));
//		[09/04/2013 04:20 PM]
	}
}
